// Sequential BOB.js
//
// this is Polygon scirpt. place this into ~/Library/Application Support/Cheetah3D/scripts/Polygonobj folder.
// updated: 20080521 - fix UV bug, cach creation bug.
// updated: 20090513 - fix bug.
// updated: 20140409 - bobj version

var SHORT_BYTES = 2;
var UINT_BYTES = 4;
var FLOAT_BYTES = 4;

var seq_filedir = '';
var seq_filename = '';
var pad = 1;

var cache_ext = 'cache';

function buildUI(obj){
    
    if( obj.family() != NGONFAMILY) { // install error check from Todd's code.:)
        OS.messageBox("Installation Error!","This script file is in the wrong folder. Please place this in the PolygonObj folder.");
        return;
    }
    obj.setParameter("name","Undefined");

    obj.addParameterFloat("frame",1,0,9999,true,true); // 

    obj.addParameterSeparator("Initialize");
    obj.addParameterInt("0 pad count",4,1,10,false,false);
    obj.addParameterButton("Set File","Set","setFile");
    obj.addParameterString("file name", "", false);
        
    obj.addParameterSeparator("Smooth"); // normal type
    obj.addParameterSelector("smooth",["flat","phong","constraint"],true,true);
    obj.addParameterFloat("smooth angle",45,1,180,true,true);
    
    obj.setParameter("smooth",2);
}

function setFile(obj) {
	var doc = obj.document();
	
	var path = OS.runOpenPanel("bobj",cache_ext);
	if (path == null) return;
	
	var file = new File(path);
	seq_filedir = file.directory();
	seq_filename = file.lastPathComponent();
	pad = obj.getParameter("0 pad count");
	
  	obj.setParameter("file name", path);
  
	//print("setFile:"+path+", setName:"+obj_name);
}


function buildObject(obj) {
    
    if (! seq_filedir && ! seq_filename) {
      var file = new File( obj.getParameter("file name") );
      if (file) {
        seq_filedir = file.directory();
        seq_filename = file.lastPathComponent();
        pad = obj.getParameter("0 pad count");
      }
    }
    
    obj.setParameter("normalType",obj.getParameter("smooth"),false);
    obj.setParameter("normalAngle",obj.getParameter("smooth angle"),false);
    
    if (seq_filedir && seq_filename) {
    	var frame = Math.floor(obj.getParameter("frame"));
	    var core = obj.core();
	    
	    var file_names = seq_filename.match(/^([^0-9]+)[0-9]+\.bobj$/);
    	//print( file_names );
		var file_name = file_names[1];
		
		var frame_char = new String(frame);
		while (frame_char.length < pad) frame_char = '0'+frame_char; // padding 0
		
		var file_path = seq_filedir + '/'+ file_name+frame_char+'.bobj';
		
		var file = new File(file_path);
		
		if (file.exist()) {
			//print("reading BOBJ file:"+file_path);
			file.open(READ_MODE, LITTLE_ENDIAN);
			if (file.isOpen() == false) {
				print("FILE ERROR:"+file_path+" is not open.");
				return;
			}
      		var i;
			var vertexCount = file.readInt();
			for ( i = 0;i < vertexCount;i++) {
				core.addVertex(false, new Vec3D( file.readFloat(), file.readFloat(), file.readFloat() ));
			}
			var normalCount = file.readInt();
			file.seek( FLOAT_BYTES * normalCount * 3, SEEK_CUR );
     
			var triCount = file.readInt();
			for (i = 0;i < triCount;i++) {
				var tris = [file.readInt(), file.readInt(), file.readInt()];
				core.addIndexPolygon(3, tris.reverse());
			}
      
			file.close();
			//print("READ FINISHED:"+vertexCount+","+triCount);
		} else {
			print("FILE ERROR:"+file_path+" is not exist.");
			return;
		}
    }
}

